//================================================================================================================================================\\
//================================================================================================================================================\\
//================================================================================================================================================\\
//                                                                                                                                                \\
//                                                                  Camera Object                                                                 \\
//                                                                                                                                                \\
//================================================================================================================================================\\
//================================================================================================================================================\\
//================================================================================================================================================\\

var camera = new Camera(320, 240);

function Camera(w, h)
{
  SetClippingRectangle(0, 0, w, h)

  this.x = 0; // Camera's x
  this.y = 0; // Camera's y
  this.w = w; // Camera's width
  this.h = h; // Camera's height
  
  this.Xoffset = (GetScreenWidth() - this.w) / 2; // The offset if the camera's width is a lower number than the screen's width
  this.Yoffset = (GetScreenHeight() - this.h) / 2; // The offset if the camera's height is a lower number than the screen's height
  
  this.player = false; // Camera is following

  this.attachCamera = function(person)
  {
    this.player = person; // Attach camera to person
    this.x = GetPersonX(person) - (this.w / 2); // Set camera x to have the person in the middle
    if (this.x < 0) this.x = 0; // Reset to 0 if x is off the left of the map
    this.y = GetPersonY(person) - (this.h / 2); // Set camera y to have the person in the middle
    if (this.y < 0) this.y = 0; // Reset to 0 if y is off the top of the map
  }
  
  this.detachCamera = function() { this.player = false; }
  
  this.mapToScreenX = function(x)
  {
    return x - this.x; // Return x of map rather than of the screen scope
  }
  
  this.mapToScreenY = function(y)
  {
    return y - this.y; // Return y of map rather than of the screen scope
  }
  
  this.screenToMapX = function(x)
  {
    return this.x + x + 40; // Return x from screen rather than of the screen scope
  }
  
  this.screenToMapY = function(y)
  {
    return this.y + y; // Return y from screen rather than of the screen scope
  }
  
  this.update = function()
  {
    var list = mapEngine.getPersonList();
    if (this.player)
    {
      this.x = mapEngine.person[mapEngine.getPersonId(this.player)].x - (this.w / 2); // Set camera x to have the person in the middle
      if (this.x < 0) this.x = 0; // Reset to 0 if x is off the left of the map
      if (this.x + this.w > mapEngine.mapWidth * mapEngine.tileWidth) this.x = (mapEngine.mapWidth * mapEngine.tileWidth) - this.w // TEMPORARY
      this.y = mapEngine.person[mapEngine.getPersonId(this.player)].y - (this.h / 2); // Set camera y to have the person in the middle
      if (this.y < 0) this.y = 0; // Reset to 0 if y is off the top of the map
      if (this.y + this.h > mapEngine.mapHeight * mapEngine.tileHeight) this.y = (mapEngine.mapHeight * mapEngine.tileHeight) - this.h // TEMPORARY
    }
  }
}